

 * =================================================================================================
* ========================= INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS - INEC ===========================
* ================== DIRECCIN DE ESTADSTICAS AGROPECUARIAS Y AMBIENTALES - DEAGA ====================
* ========================== REGISTRO INTEGRAL DE RESIDUOS SLIDOS- GIRS 2024 ==========================
* ============================= SINTAXIS DE ELABORACIN DE TABULADOS =================================
* ============================= ELABORADO POR: WILSON MONTEROS ====================================
* ======================================== NOVIEMBRE 2025 ===========================================
* ======================================== TABULADOS  ==============================================


***********************************MUNICIPIOS***********************************

******************CLCULO DE TABULADOS - RESIDUOS 2024************


**************************TABULADO 1 *******************************************


*****Municipios que cuentan con ordenanza para el manejo de Residuos Slidos****


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MR19 DISPLAY=LABEL
  /TABLE BY MR19 [C][COUNT F40.0, ROWPCT.COUNT PCT40.2]
  /CATEGORIES VARIABLES=MR19 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' POSITION=AFTER    
  /TITLES
    TITLE='Tab 1: Municipios que cuentan con ordenanza para el manejo de Residuos Slidos'
    CAPTION="Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.".


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu MR19 DISPLAY=LABEL
  /TABLE rgnatu BY MR19 [C][COUNT F40.0, ROWPCT.COUNT PCT40.2]
  /CATEGORIES VARIABLES=rgnatu [1.00, 2.00, 3.00, 4.00, 5.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES 
    LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR19 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' POSITION=AFTER    
  /TITLES
    TITLE='Tab 1.1: Municipios que cuentan con ordenanza para el manejo de Residuos Slidos, Segn Regines Naturales'
    CAPTION="Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.".


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin MR19 DISPLAY=LABEL
  /TABLE Provin [C] BY MR19 [C][COUNT F40.0, ROWPCT.COUNT PCT40.2]
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 
    20, 21, 22, 23, 24, 90, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR19 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' POSITION=AFTER   
  /TITLES
   TITLE='Tab 1.2: Municipios que cuentan con ordenanza para el manejo de Residuos Slidos, Segn Provincias'
    CAPTION="Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.".



**************************TABULADO 2 *******************************************


******* Municipios que cuentan con Sistema de Tratamiento y/o Disposicin Final de los Desechos Peligrosos Sanitarios****


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MR4737 DISPLAY=LABEL
  /TABLE BY MR4737 [C][COUNT F40.0, ROWPCT.COUNT PCT40.2]
  /CATEGORIES VARIABLES=MR4737 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' POSITION=AFTER    
  /TITLES
    TITLE=' Tab 2: Municipios que cuentan con Sistema de Tratamiento y/o Disposicin Final de los Desechos Peligrosos Sanitarios'
    CAPTION="Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.".


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu MR4737 DISPLAY=LABEL
  /TABLE rgnatu BY MR4737 [C][COUNT F40.0, ROWPCT.COUNT PCT40.2]
  /CATEGORIES VARIABLES=rgnatu [1.00, 2.00, 3.00, 4.00, 5.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES 
    LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR4737 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' POSITION=AFTER    
  /TITLES
    TITLE=' Tab 2.1: Municipios que cuentan con Sistema de Tratamiento y/o Disposicin Final de los Desechos Peligrosos Sanitarios, Segn Regines Naturales'
    CAPTION="Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.".



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin MR4737 DISPLAY=LABEL
  /TABLE Provin [C] BY MR4737 [C][COUNT F40.0, ROWPCT.COUNT PCT40.2]
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 
    20, 21, 22, 23, 24, 90, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR4737 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' POSITION=AFTER    
  /TITLES
    TITLE=' Tab 2.2: Municipios que cuentan con Sistema de Tratamiento y/o Disposicin Final de los Desechos Peligrosos Sanitarios, Segn Provincias'
    CAPTION="Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.".




**************************TABULADO 3 *******************************************


*************Costos Operativos por sitio de disposicin final (mediana y suma)



*****************Mediana*********************


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MR461 CT MR243 DISPLAY=LABEL
  /TABLE BY MR461 [C] > (CT [S][MEDIAN] + MR243 [S][MEDIAN, MEAN, COUNT F40.0])
  /CATEGORIES VARIABLES=MR461 ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='COSTOS OPERATIVOS POR SITIO DE DISPOSICIN FINAL'
    CAPTION=' Tab 3: Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu MR461 CT MR243 DISPLAY=LABEL
  /TABLE rgnatu BY MR461 [C] > (CT [S][MEDIAN] + MR243 [S][MEDIAN, MEAN, COUNT F40.0])
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR461 ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='COSTOS OPERATIVOS POR SITIO DE DISPOSICIN FINAL, SEGN REGIONES NATURALES'
    CAPTION=' Tab 3.1: Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin MR461 CT MR243 DISPLAY=LABEL
  /TABLE Provin BY MR461 [C] > (CT [S][MEDIAN] + MR243 [S][MEDIAN, MEAN, COUNT F40.0])
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 90, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR461 ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='COSTOS OPERATIVOS POR SITIO DE DISPOSICIN FINAL, SEGN REGIONES NATURALES'
    CAPTION=' Tab 3.2: Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.

*Nota: El costo por sitio de disposicin final hay que hacerlo manulamente en Excel.




*****************Suma*********************


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MR461 CT MR243 DISPLAY=LABEL
  /TABLE BY MR461 [C] > (CT [S][SUM] + MR243 [S][SUM, MEAN, COUNT F40.0])
  /CATEGORIES VARIABLES=MR461 ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='COSTOS OPERATIVOS POR SITIO DE DISPOSICIN FINAL'
    CAPTION=' Tab 3: Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu MR461 CT MR243 DISPLAY=LABEL
  /TABLE rgnatu BY MR461 [C] > (CT [S][SUM] + MR243 [S][SUM, MEAN, COUNT F40.0])
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR461 ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='COSTOS OPERATIVOS POR SITIO DE DISPOSICIN FINAL, SEGN REGIONES NATURALES'
    CAPTION=' Tab 3.1: Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin MR461 CT MR243 DISPLAY=LABEL
  /TABLE Provin BY MR461 [C] > (CT [S][SUM] + MR243 [S][SUM, MEAN, COUNT F40.0])
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 90, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR461 ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='COSTOS OPERATIVOS POR SITIO DE DISPOSICIN FINAL, SEGN REGIONES NATURALES'
    CAPTION=' Tab 3.2: Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.





**************************TABULADO 4 *******************************************


***** Municipios que realizarn caracterizacin de Residuos Slidos producidos en el Cantn****



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MR431 DISPLAY=LABEL
  /TABLE BY MR431 [COUNT F40.0, ROWPCT.COUNT PCT40.2]
  /CATEGORIES VARIABLES=MR431 [1, 2, OTHERNM] EMPTY=INCLUDE TOTAL=YES LABEL='Municipios' 
    POSITION=AFTER
  /TITLES
    TITLE=' Municipios que realizarn caracterizacin de Residuos Slidos producidos en el Cantn'
    CAPTION=" Tab 4: Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.".



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu MR431 DISPLAY=LABEL
  /TABLE rgnatu BY MR431 [C][COUNT F40.0, ROWPCT.COUNT PCT40.2]
  /CATEGORIES VARIABLES=rgnatu [1.00, 2.00, 3.00, 4.00, 5.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES 
    LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR431 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' 
    POSITION=AFTER
  /TITLES
    TITLE=' Municipios que realizarn caracterizacin de Residuos Slidos producidos en el Cantn, Segn Regines Naturales'
    CAPTION=" Tab 4.1: Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.".



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin MR431 DISPLAY=LABEL
  /TABLE Provin BY MR431 [C][COUNT F40.0, ROWPCT.COUNT PCT40.2]
  /CATEGORIES VARIABLES=Provin [1.00, 2.00, 3.00, 4.00, 5.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES 
    LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR431 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' 
    POSITION=AFTER
  /TITLES
    TITLE=' Municipios que realizarn caracterizacin de Residuos Slidos producidos en el Cantn, Segn Provincias'
    CAPTION=" Tab 4.2: Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.".




**************************TABULADO 5 *******************************************

***** Municipios que realizarn caracterizacin de Residuos Slidos Producidos ***


compute TCRO  = MR43111.
variable labels TCRO 'Caracterizacin Residuos Orgnicos (Urbano)'.
execute.

compute TCRI = sum.1 ( MR43112, MR43113, MR43114, MR43115, MR43116, MR43117, MR43118, 
                                     MR43119, MR431110, MR431111, MR431112, MR431113, MR431114, MR431115).
variable labels TCRI 'Caracterizacin Residuos Inorgnicos (Urbano)'.
execute.

compute TCROIU = sum.1 (MR43111, MR43112, MR43113, MR43114, MR43115, MR43116, MR43117, MR43118, 
                                     MR43119, MR431110, MR431111, MR431112, MR431113, MR431114, MR431115).
variable labels TCROIU ' Caracterizacin Total de Residuos (Urbano)'.
execute.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=TCRO TCRI TCROIU  DISPLAY=LABEL
  /TABLE BY TCRO [S][SUM] + TCRI [S][SUM] + TCROIU [S][SUM, TOTALN]
  /TITLES
    TITLE=' Tab 5: Caracterizacin de los Residuos Slidos Producidos (Area Urbana)'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu TCRO TCRI TCROIU DISPLAY=LABEL
  /TABLE rgnatu BY TCRO [S][SUM] + TCRI [S][SUM] + TCROIU [S][SUM,  TOTALN]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /TITLES
    TITLE=' Tab 5.1: Caracterizacin de los Residuos Slidos Producidos (Area Urbana), Segn Regiones Naturales'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin TCRO TCRI TCROIU DISPLAY=LABEL
  /TABLE Provin BY TCRO [S][SUM] + TCRI [S][SUM] + TCROIU [S][SUM,  TOTALN] 
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 90, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /TITLES
    TITLE=' Tab 5.2: Caracterizacin de los Residuos Slidos Producidos (Area Urbana), Segn Provincias'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.



**************************TABULADO 6 *******************************************.

******Caracterizacin de los Residuos Slidos Producidos por el Tipo de Residuo*****


compute TCROI = sum.1 (MR43111, MR43112, MR43113, MR43114, MR43115, MR43116, MR43117, MR43118, 
                                     MR43119, MR431110, MR431111, MR431112, MR431113, MR431114, MR431115).
variable labels TCROI 'Total'.
execute.


compute PORG = MR43111 / TCROI * 100.
variable labels PORG 'Orgnico'.

compute PCAR = MR43112 / TCROI * 100.
variable labels PCAR 'Cartn'.

compute PPAP = MR43113 / TCROI * 100.
variable labels PPAP 'Papel'.

compute PPR = MR43114 / TCROI * 100.
variable labels PPR 'Plstico rgido'.

compute PPS = MR43115 / TCROI * 100.
variable labels PPS 'Plstico suave'.

compute PVID = MR43116 / TCROI * 100.
variable labels PVID 'Vidrio'.

compute PMAD = MR43117 / TCROI * 100.
variable labels PMAD 'Madera'.

compute PMET = MR43118 / TCROI * 100.
variable labels PMET 'Metal'.

compute PCHA = MR43119 / TCROI * 100.
variable labels PCHA 'Chatarra'.

compute PCAU = MR431110 / TCROI * 100.
variable labels PCAU 'Caucho'.

compute PTEX = MR431111 / TCROI * 100.
variable labels PTEX 'Textil'.

compute PLFA = MR431112 / TCROI * 100.
variable labels PLFA 'Lmparas desechables/ focos comunes/ focos ahorradores'.

compute PPIL = MR431113 / TCROI * 100.
variable labels PPIL 'Pilas'.

compute PPDPT = MR431114 / TCROI * 100.
variable labels PPDPT 'Paales Desechables, papel higienico, toallas sanitarias'.

compute POTROS = MR431115 / TCROI * 100.
variable labels POTROS 'Otros'.

compute PTOTAL = TCROI / TCROI * 100.
variable labels PTOTAL 'Total'.

execute.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PORG PCAR PPAP PPR PPS PVID PMAD PMET PCHA PCAU PTEX PLFA PPIL PPDPT POTROS PTOTAL
    DISPLAY=LABEL
  /TABLE BY PORG [S][SUM] + PCAR [S][SUM] + PPAP [S][SUM] + PPR [S][SUM] + PPS [S][SUM] + PVID [S][SUM] + PMAD [S][SUM] +
 PMET [S][SUM] + PCHA [S][SUM] + PCAU [S][SUM] + PTEX [S][SUM] + PLFA [S][SUM] + PPIL [S][SUM] + PPDPT [S][SUM] + POTROS
[S][SUM] + PTOTAL [S][SUM]
  /TITLES
    TITLE='Tab 6: Caracterizacin de los Residuos Slidos Producidos por el Tipo de Residuo (Area Urbana)'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu PORG PCAR PPAP PPR PPS PVID PMAD PMET PCHA PCAU PTEX PLFA PPIL PPDPT POTROS PTOTAL
    DISPLAY=LABEL
  /TABLE rgnatu [C] BY PORG [S][SUM] + PCAR [S][SUM] + PPAP [S][SUM] + PPR [S][SUM] + PPS [S][SUM] + PVID [S][SUM] + PMAD [S][SUM] + 
PMET [S][SUM] + PCHA [S][SUM] + PCAU [S][SUM] + PTEX [S][SUM] + PLFA [S][SUM] + PPIL [S][SUM] + PPDPT
[S][SUM] + POTROS [S][SUM] + PTOTAL [S][SUM]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /TITLES
    TITLE='Tab 6.1: Caracterizacin de los Residuos Slidos Producidos por el Tipo de Residuo (Area Urbana), Segn Regiones Naturales'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin PORG PCAR PPAP PPR PPS PVID PMAD PMET PCHA PCAU PTEX PLFA PPIL PPDPT POTROS PTOTAL
    DISPLAY=LABEL
  /TABLE Provin BY PORG [S][SUM] + PCAR [S][SUM] + PPAP [S][SUM] + PPR [S][SUM] + PPS [S][SUM] + PVID [S][SUM] + PMAD [S][SUM] + 
PMET [S][SUM] + PCHA [S][SUM] + PCAU [S][SUM] + PTEX [S][SUM] + PLFA [S][SUM] + PPIL [S][SUM] + PPDPT [S][SUM] +
POTROS [S][SUM] + PTOTAL [S][SUM]
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 90, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /TITLES
    TITLE=' Tab 6.2: Caracterizacin de los Residuos Slidos Producidos por el Tipo de Residuo (Area Urbana), Segn Provincias'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.




**************************TABULADO 7 ********************************************.


*** Municipios que Trabajan con Separacin en la Fuente a Nivel Domiciliar****



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MR433 DISPLAY=LABEL
  /TABLE BY MR433 [COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=MR433 [1, 2, OTHERNM] EMPTY=INCLUDE TOTAL=YES LABEL='Municipios' POSITION=AFTER
  /TITLES
    TITLE=' Tab 7: Municipios que Trabajan con Separacin en la Fuente a Nivel Domiciliar'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu MR433 DISPLAY=LABEL
  /TABLE rgnatu BY MR433 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR433 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' POSITION=AFTER
  /TITLES
    TITLE=' Tab 7.1: Municipios que Trabajan con Separacin en la Fuente a Nivel Domiciliar, Segn Regiones Naturales'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin MR433 DISPLAY=LABEL
  /TABLE Provin BY MR433 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 90, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR433 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' POSITION=AFTER
  /TITLES
    TITLE=' Tab 7.2: Municipios que Trabajan con Separacin en la Fuente a Nivel Domiciliar, Segn Provincias'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.



**************************TABULADO 8 ********************************************.


***Municipios que realizarn Recoleccin Diferenciada de Residuos Slidos****


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MR452 DISPLAY=LABEL
  /TABLE BY MR452 [COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=MR452 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE=' Tab 8: Municipios que realizarn Recoleccin Diferenciada de Residuos Slidos'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu MR452 DISPLAY=LABEL
  /TABLE rgnatu BY MR452 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR452 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE=' Tab 8.1: Municipios que realizarn Recoleccin Diferenciada de Residuos Slidos, Segn Regiones Naturales'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin MR452 DISPLAY=LABEL
  /TABLE Provin BY MR452 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 90, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR452 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE=' Tab 8.2: Municipios que realizarn Recoleccin Diferenciada de Residuos Slidos, Segn Provincias'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.




**************************TABULADO 9 ********************************************.


*****Municipios que Aprovechan los Residuos Slidos Orgnicos de los Mercados******



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MR441 DISPLAY=LABEL
  /TABLE BY MR441 [COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=MR441 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE=' Tab 9: Municipios que aprovecha los Residuos Slidos Orgnicos de los Mercados'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu MR441 DISPLAY=LABEL
  /TABLE rgnatu BY MR441 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR441 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE=' Tab 9.1: Municipios que aprovecha los Residuos Slidos Orgnicos de los Mercados, Segn Regiones Naturales'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin MR441 DISPLAY=LABEL
  /TABLE Provin BY MR441 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=Provin ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR441 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE=' Tab 9.2: Municipios que aprovecha los Residuos Slidos Orgnicos de los Mercados, Segn Provincias'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.





**************************TABULADO 10 *******************************************


*****Municipios que realizarn Tratamiento a los Residuos Orgnicos de los Mercados para su Aprovechamiento****



if (MR4411 = 1 and MR4412 = 2 and MR4413 = 2 and MR4414 = 2 and MR4415 = 2) MTRO = 1.
if (MR4411 = 2 and MR4412 = 1 and MR4413 = 2 and MR4414 = 2 and MR4415 = 2) MTRO = 2.
if (MR4411 = 2 and MR4412 = 2 and MR4413 = 1 and MR4414 = 2 and MR4415 = 2) MTRO = 3.
if (MR4411 = 2 and MR4412 = 2 and MR4413 = 2 and MR4414 = 1 and MR4415 = 2) MTRO = 4.
if (MR4411 = 2 and MR4412 = 2 and MR4413 = 2 and MR4414 = 2 and MR4415 = 1) MTRO = 5.

if (MR4411 = 1 and MR4412 = 1 and MR4413 = 2 and MR4414 = 2 and MR4415 = 2) MTRO = 6.
if (MR4411 = 1 and MR4412 = 2 and MR4413 = 1 and MR4414 = 2 and MR4415 = 2) MTRO = 7.
if (MR4411 = 1 and MR4412 = 2 and MR4413 = 2 and MR4414 = 1 and MR4415 = 2) MTRO = 8.
if (MR4411 = 1 and MR4412 = 2 and MR4413 = 2 and MR4414 = 2 and MR4415 = 1) MTRO = 9.

if (MR4411 = 2 and MR4412 = 1 and MR4413 = 1 and MR4414 = 2 and MR4415 = 2) MTRO = 10.
if (MR4411 = 2 and MR4412 = 1 and MR4413 = 2 and MR4414 = 1 and MR4415 = 2) MTRO = 11.
if (MR4411 = 2 and MR4412 = 1 and MR4413 = 2 and MR4414 = 2 and MR4415 = 1) MTRO = 12.

if (MR4411 = 2 and MR4412 = 2 and MR4413 = 1 and MR4414 = 1 and MR4415 = 2) MTRO = 13.
if (MR4411 = 2 and MR4412 = 2 and MR4413 = 1 and MR4414 = 2 and MR4415 = 1) MTRO = 14.

if (MR4411 = 2 and MR4412 = 2 and MR4413 = 2 and MR4414 = 1 and MR4415 = 1) MTRO = 15.

if (MR4411 = 1 and MR4412 = 1 and MR4413 = 2 and MR4414 = 1 and MR4415 = 2) MTRO = 16.
if (MR4411 = 1 and MR4412 = 1 and MR4413 = 1 and MR4414 = 2 and MR4415 = 2) MTRO = 17.
recode MTRO ( sysmis = 18).
value labels MTRO
1 'Compostaje'
2 'Lombricultura'
3 'Bocashi'
4 'Takakura'
5 'Otros'
6 'Compostaje y Lombricultura'
7 'Compostaje y Bocashi'
8 'Compostaje y Takakura'
9 'Compostaje y Otros'
10 'Lombricultura y Bocashi'
11 'Lombricultura y Takakura'
12 'Lombricultura y Otros'
13 'Bocashi y Takakura'
14 'Bocashi y Otros'
15 'Takakura y Otros'
16 'Compostaje, Lombricultura y Takakura'
17 'Compostaje, Lombricultura y Bocashi'
18 'No tiene tratamiento'.
variable labels MTRO 'Municipios que realizarn Tratamiento a los Residuos Orgnicos de los Mercados para su aprovechamiento'.




* Definir propiedades de variables.
*Pob.
VARIABLE LEVEL  MTRO(NOMINAL).
EXECUTE.


* Tablas personalizadas. 
CTABLES 
  /VLABELS VARIABLES=MTRO DISPLAY=LABEL 
  /TABLE BY MTRO [COUNT F40.0, ROWPCT.VALIDN PCT40.2] 
  /CATEGORIES VARIABLES=MTRO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' 
    POSITION=AFTER 
   /TITLES 
    TITLE=' Tab 10: Municipios que realizarn Tratamiento a los Residuos Orgnicos de los Mercados para '+ 
    'su aprovechamiento' 
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu MTRO DISPLAY=LABEL
  /TABLE rgnatu BY MTRO [COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MTRO [1.00, 2.00, 3.00, 4.00, 5.00, 6.00, 7.00, 8.00, 9.00, 10.00, 11.00, 12.00, 13.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' POSITION=AFTER
  /TITLES
    TITLE='Tab10.1: Municipios que realizarn Tratamiento a los Residuos Orgnicos de los Mercados para su Aprovechamiento, Segn Regiones Naturales'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin MTRO DISPLAY=LABEL
  /TABLE Provin BY MTRO [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 90, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MTRO [1.00, 2.00, 3.00, 4.00, 5.00, 6.00, 7.00, 8.00, 9.00, 10.00, 11.00, 12.00, 13.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' POSITION=AFTER
  /TITLES
    TITLE='Tab 10.2: Municipios que realizarn Tratamiento a los Residuos Orgnicos de los Mercados para su Aprovechamiento, Segn Provincias'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.




**************************TABULADO 11 ********************************************.



*****Municipios que Aprovechan los Residuos (domsticos) Orgnicos de la Ciudad******



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MR442 DISPLAY=LABEL
  /TABLE BY MR442 [COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=MR442 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE=' Tab 11: Municipios que aprovecha los Residuos (Domsticos) Orgnicos de la Ciudad'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu MR442 DISPLAY=LABEL
  /TABLE rgnatu BY MR442 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR442 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE=' Tab 11.1: Municipios que aprovecha los Residuos (Domsticos) Orgnicos de la Ciudad, Segn Regiones Naturales'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin MR442 DISPLAY=LABEL
  /TABLE Provin BY MR442 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=Provin ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MR442 [1, 2, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE=' Tab 11.2: Municipios que aprovecha los Residuos (Domsticos) Orgnicos de la Ciudad, Segn Provincias'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.




**************************TABULADO 12 *******************************************


*****Municipios que realizarn Tratamiento a los Residuos (Domsticos) Orgnicos de la Ciudad para su Aprovechamiento****


if (MR4421 = 1 and MR4422 = 2 and MR4423 = 2 and MR4424 = 2 and MR4425 = 2) MTROD = 1.
if (MR4421 = 2 and MR4422 = 1 and MR4423 = 2 and MR4424 = 2 and MR4425 = 2) MTROD = 2.
if (MR4421 = 2 and MR4422 = 2 and MR4423 = 1 and MR4424 = 2 and MR4425 = 2) MTROD = 3.
if (MR4421 = 2 and MR4422 = 2 and MR4423 = 2 and MR4424 = 1 and MR4425 = 2) MTROD = 4.
if (MR4421 = 2 and MR4422 = 2 and MR4423 = 2 and MR4424 = 2 and MR4425 = 1) MTROD = 5.

if (MR4421 = 1 and MR4422 = 1 and MR4423 = 2 and MR4424 = 2 and MR4425 = 2) MTROD = 6.
if (MR4421 = 1 and MR4422 = 2 and MR4423 = 1 and MR4424 = 2 and MR4425 = 2) MTROD = 7.
if (MR4421 = 1 and MR4422 = 2 and MR4423 = 2 and MR4424 = 1 and MR4425 = 2) MTROD = 8.
if (MR4421 = 1 and MR4422 = 2 and MR4423 = 2 and MR4424 = 2 and MR4425 = 1) MTROD = 9.

if (MR4421 = 2 and MR4422 = 1 and MR4423 = 1 and MR4424 = 2 and MR4425 = 2) MTROD = 10.
if (MR4421 = 2 and MR4422 = 1 and MR4423 = 2 and MR4424 = 1 and MR4425 = 2) MTROD = 11.
if (MR4421 = 2 and MR4422 = 1 and MR4423 = 2 and MR4424 = 2 and MR4425 = 1) MTROD = 12.

if (MR4421 = 2 and MR4422 = 2 and MR4423 = 1 and MR4424 = 1 and MR4425 = 2) MTROD = 13.
if (MR4421 = 2 and MR4422 = 2 and MR4423 = 1 and MR4424 = 2 and MR4425 = 1) MTROD = 14.

if (MR4421 = 2 and MR4422 = 2 and MR4423 = 2 and MR4424 = 1 and MR4425 = 1) MTROD = 15.

if (MR4421 = 1 and MR4422 = 1 and MR4423 = 2 and MR4424 = 1 and MR4425 = 2) MTROD = 16.
if (MR4421 = 1 and MR4422 = 1 and MR4423 = 1 and MR4424 = 2 and MR4425 = 2) MTROD = 17.
if (MR4421 = 1 and MR4422 = 1 and MR4423 = 2 and MR4424 = 2 and MR4425 = 1) MTROD = 18.

recode MTROD ( sysmis = 19).
value labels MTROD
1 'Compostaje'
2 'Lombricultura'
3 'Bocashi'
4 'Takakura'
5 'Otros'
6 'Compostaje y Lombricultura'
7 'Compostaje y Bocashi'
8 'Compostaje y Takakura'
9 'Compostaje y Otros'
10 'Lombricultura y Bocashi'
11 'Lombricultura y Takakura'
12 'Lombricultura y Otros'
13 'Bocashi y Takakura'
14 'Bocashi y Otros'
15 'Takakura y Otros'
16 'Compostaje, Lombricultura y Takakura'
17 'Compostaje, Lombricultura y Bocashi'
18 'Compostaje, Lombricultura y Otros'
19 'No tiene tratamiento'.
variable labels MTROD 'Municipios que realizarn Tratamiento a los Residuos (Domsticos) Orgnicos de la Ciudad para su aprovechamiento'.



* Definir propiedades de variables.
*Pob.
VARIABLE LEVEL  MTROD(NOMINAL).
EXECUTE.


* Tablas personalizadas. 
CTABLES 
  /VLABELS VARIABLES=MTROD DISPLAY=LABEL 
  /TABLE BY MTROD [COUNT F40.0, ROWPCT.VALIDN PCT40.2] 
  /CATEGORIES VARIABLES=MTROD ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' 
    POSITION=AFTER 
   /TITLES 
    TITLE=' Tab 12: Municipios que realizarn Tratamiento a los Residuos Orgnicos de los Mercados para '+ 
    'su aprovechamiento' 
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu MTROD DISPLAY=LABEL
  /TABLE rgnatu BY MTROD [COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MTROD [1.00, 2.00, 3.00, 4.00, 5.00, 6.00, 7.00, 8.00, 9.00, 10.00, 11.00, 12.00, 13.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' POSITION=AFTER
  /TITLES
    TITLE='Tab12.1: Municipios que realizarn Tratamiento a los Residuos Orgnicos de los Mercados para su Aprovechamiento, Segn Regiones Naturales'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin MTROD DISPLAY=LABEL
  /TABLE Provin BY MTROD [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 90, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MTROD [1.00, 2.00, 3.00, 4.00, 5.00, 6.00, 7.00, 8.00, 9.00, 10.00, 11.00, 12.00, 13.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' POSITION=AFTER
  /TITLES
    TITLE='Tab 12.2: Municipios que realizarn Tratamiento a los Residuos Orgnicos de los Mercados para su Aprovechamiento, Segn Provincias'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.



**************************TABULADO 13 *******************************************


*****Mecanismos de cobro de la Tasa de Recoleccin de los Residuos Slidos*****



if (MR22101 = 1 and MR22102 = 2 and MR22103 = 2 and MR22104 = 2 and MR22105 = 2) MCTR = 1.
if (MR22101 = 2 and MR22102 = 1 and MR22103 = 2 and MR22104 = 2 and MR22105 = 2) MCTR = 2.
if (MR22101 = 2 and MR22102 = 2 and MR22103 = 1 and MR22104 = 2 and MR22105 = 2) MCTR = 3.
if (MR22101 = 2 and MR22102 = 2 and MR22103 = 2 and MR22104 = 1 and MR22105 = 2) MCTR = 4.
if (MR22101 = 2 and MR22102 = 2 and MR22103 = 2 and MR22104 = 2 and MR22105 = 1) MCTR = 5.
if (MR22101 = 1 and MR22102 = 1 and MR22103 = 2 and MR22104 = 2 and MR22105 = 2) MCTR = 6.
if (MR22101 = 1 and MR22102 = 2 and MR22103 = 1 and MR22104 = 2 and MR22105 = 2) MCTR = 7.
if (MR22101 = 1 and MR22102 = 2 and MR22103 = 2 and MR22104 = 1 and MR22105 = 2) MCTR = 8.
if (MR22101 = 1 and MR22102 = 2 and MR22103 = 2 and MR22104 = 2 and MR22105 = 1) MCTR = 9.
if (MR22101 = 2 and MR22102 = 1 and MR22103 = 1 and MR22104 = 2 and MR22105 = 2) MCTR = 10.
if (MR22101 = 2 and MR22102 = 1 and MR22103 = 2 and MR22104 = 1 and MR22105 = 2) MCTR = 11.
if (MR22101 = 2 and MR22102 = 1 and MR22103 = 1 and MR22104 = 2 and MR22105 = 1) MCTR = 12.
if (MR22101 = 2 and MR22102 = 2 and MR22103 = 1 and MR22104 = 1 and MR22105 = 2) MCTR = 13.
if (MR22101 = 1 and MR22102 = 1 and MR22103 = 1 and MR22104 = 2 and MR22105 = 2) MCTR = 14.
if (MR22101 = 2 and MR22102 = 2 and MR22103 = 2 and MR22104 = 1 and MR22105 = 1) MCTR = 15.
if (MR22101 = 2 and MR22102 = 1 and MR22103 = 1 and MR22104 = 1 and MR22105 = 2) MCTR = 16.
if (MR22101 = 1 and MR22102 = 2 and MR22103 = 1 and MR22104 = 1 and MR22105 = 2) MCTR = 17.
if (MR22101 = 1 and MR22102 = 1 and MR22103 = 2 and MR22104 = 1 and MR22105 = 2) MCTR = 18.
if (MR22101 = 1 and MR22102 = 1 and MR22103 = 1 and MR22104 = 1 and MR22105 = 2) MCTR = 19.
if (MR22101 = 1 and MR22102 = 1 and MR22103 = 2 and MR22104 = 2 and MR22105 = 1) MCTR = 20.
if (MR22101 = 1 and MR22102 = 2 and MR22103 = 1 and MR22104 = 2 and MR22105 = 1) MCTR = 21.
if (MR22101 = 2 and MR22102 = 1 and MR22103 = 2 and MR22104 = 1 and MR22105 = 1) MCTR = 22.
if (MR22101 = 2 and MR22102 = 1 and MR22103 = 2 and MR22104 = 2 and MR22105 = 1) MCTR = 23.
if (MR2210 = 2) MCTR = 24.



value labels MCTR
1 'Energa Elctrica'
2 'Agua Potable'
3 'Impuesto Predial'
4 'Facturacin directa por Municipio'
5 'Otros'
6 'Energa Elctrica y Agua Potable'
7 'Energa Elctrica y Impuesto Predial'
8 'Energa Elctrica y Facturacin directa por Municipio'
9 'Energa Elctrica y Otros'
10 'Agua Potable y Impuesto Predial'
11 'Agua Potable y Facturacin directa por Municipio'
12 'Agua Potable, Impuesto Predial y Otros'
13 'Impuesto Predial y Facturacin directa por Municipio'
14 'Energa Elctrica, Agua Potable y Impuesto Predial'
15 'Facturacin directa por Municipio y Otros'
16 'Agua Potable, Impuesto Predial y Facturacin directa por Municipio'
17 'Energa Elctrica, Impuesto Predial y Facturacin directa por Municipio'
18 'Energa Elctrica, Agua Potable y Facturacin directa por Municipio'
19 'Energa Elctrica, Agua Potable, Impuesto Predial y Facturacin directa por Municipio'
20 'Energa Elctrica, Agua Potable y Otros'
21 'Energa Elctrica, Impuesto Predial y Otros'
22 'Agua Potable, Facturacin directa por Municipio y Otros'
23 'Agua Potable y Otros'
24 'No existe reglamento para el cobro de la Tasa de recoleccin'.
variable labels MCTR 'Mecanismos de cobro de la Tasa de Recoleccin de los Residuos Slidos'.




* Definir propiedades de variables.
*Pob.
VARIABLE LEVEL  MCTR(NOMINAL).
EXECUTE.

* Tablas personalizadas. 
CTABLES 
  /VLABELS VARIABLES=MCTR DISPLAY=LABEL 
  /TABLE BY MCTR [COUNT F40.0, ROWPCT.VALIDN PCT40.2] 
  /CATEGORIES VARIABLES=MCTR ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES LABEL='Municipios' 
    POSITION=AFTER 
   /TITLES 
    TITLE='Tab 13: Mecanismos de cobro de la Tasa de Recoleccin de los Residuos Slidos'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu MCTR DISPLAY=LABEL
  /TABLE rgnatu [C] BY MCTR [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MCTR [1.00, 2.00, 3.00, 4.00, 5.00, 6.00, 7.00, 8.00, 9.00, 10.00, 11.00, 12.00, 13.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE='Tab 13.1: Mecanismos de cobro de la Tasa de Recoleccin de los Residuos Slidos, Segn Regiones Naturales'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin MCTR DISPLAY=LABEL
  /TABLE Provin BY MCTR [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 90, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MCTR [1.00, 2.00, 3.00, 4.00, 5.00, 6.00, 7.00, 8.00, 9.00, 10.00, 11.00, 12.00, 13.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE='Tab 13.2: Mecanismos de cobro de la Tasa de Recoleccin de los Residuos Slidos, Segn Provincias'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.




**************************TABULADO 14 *******************************************


***********Sistema de Gestin de Desechos Sanitarios************


recode MR473711 (0=SYSMIS).
execute.


USE ALL.
COMPUTE filter_$=(MR473711 <= 4).
VARIABLE LABEL filter_$ 'MR473711 <= 4 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.


if (MR4731 = 1 or MR4732 = 1) MGDSP = 1.
if (MR4733 = 1 ) MGDSP = 2.


value labels MGDSP
1 'Gestin Directa o Empresa Pblica'
2 'Gestor Ambiental'.

variable labels MGDSP 'Sistema de Gestin de Desechos Sanitarios '.
EXECUTE.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MGDSP DISPLAY=LABEL
  /TABLE BY MGDSP [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=MGDSP [1.00, 2.00, OTHERNM] EMPTY=INCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE='Tab 14: Sistema de Gestin de Desechos Sanitarios '
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu MGDSP DISPLAY=LABEL
  /TABLE rgnatu BY MGDSP [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MGDSP [1.00, 2.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE='Tab 14.1:Sistema de Gestin de Desechos Sanitarios, Segn Regiones Naturales '
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Provin MGDSP DISPLAY=LABEL
  /TABLE Provin BY MGDSP [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=Provin ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=MGDSP [1.00, 2.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=AFTER
  /TITLES
    TITLE='Tab 14.2: Sistema de Gestin de Desechos Sanitarios, Segn Regiones Naturales '
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.



**********************************************************************************************************************
*******************************************FIN***********************************************************************